IF OBJECT_ID('RC_CLI_CONV_RC_ADM_CARTAO') IS NULL
BEGIN
	CREATE TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO](
		[CD_EMP] [int] NOT NULL,
		[CD_CONV] [int] NOT NULL,
		[CD_ADM_CARTAO] [int] NOT NULL,
	 CONSTRAINT [PK_RC_CLI_CONV_RC_ADM_CARTAO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_CONV] ASC,
		[CD_ADM_CARTAO] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_ADM_CARTAO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_ADM_CARTAO_CD_CONV]  DEFAULT ((0)) FOR [CD_CONV]

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_ADM_CARTAO_CD_ADM_CARTAO]  DEFAULT ((0)) FOR [CD_ADM_CARTAO]

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO]  WITH CHECK ADD  CONSTRAINT [FK_RC_CLI_CONV_RC_ADM_CARTAO_RC_CLI_CONV_RC_ADM_CARTAO] FOREIGN KEY([CD_EMP], [CD_ADM_CARTAO])
	REFERENCES [dbo].[RC_ADM_CARTAO] ([CD_EMP], [CD_ADM_CARTAO])

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO] CHECK CONSTRAINT [FK_RC_CLI_CONV_RC_ADM_CARTAO_RC_CLI_CONV_RC_ADM_CARTAO]

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO]  WITH CHECK ADD  CONSTRAINT [FK_RC_CLI_CONV_RC_ADM_CARTAO_RC_CLI_CONV] FOREIGN KEY([CD_EMP], [CD_CONV])
	REFERENCES [dbo].[RC_CLI_CONV] ([CD_EMP], [CD_CONV])

	ALTER TABLE [dbo].[RC_CLI_CONV_RC_ADM_CARTAO] CHECK CONSTRAINT [FK_RC_CLI_CONV_RC_ADM_CARTAO_RC_CLI_CONV]

	CREATE UNIQUE INDEX UK_RC_CLI_CONV_RC_ADM_CARTAO_CD_EMP_CD_CONV ON RC_CLI_CONV_RC_ADM_CARTAO (CD_EMP, CD_CONV)
END


